// Logic for login/logout via Google/Lichess API

export function initAuth() {
    const modal = document.getElementById("login-modal");
    const closeModal = document.getElementById("close-modal");
    const signInBtnMobile = document.getElementById("sign-in-btn-mobile");
    const signInBtnDesktop = document.getElementById("sign-in-btn-desktop");
    const googleAuthBtn = document.getElementById("google-auth-btn");
    const lichessAuthBtn = document.getElementById("lichess-auth-btn");
    if (!modal) return;
    const openModal = () => {
        modal.style.display = "flex";
    };
    const closeModalFunc = () => {
        modal.style.display = "none";
    };
    if (signInBtnMobile) signInBtnMobile.addEventListener("click", openModal);
    if (signInBtnDesktop) signInBtnDesktop.addEventListener("click", openModal);
    if (closeModal) closeModal.addEventListener("click", closeModalFunc);
    window.addEventListener("click", (event) => {
        if (event.target === modal) closeModalFunc();
    });
    if (googleAuthBtn) {
        googleAuthBtn.addEventListener("click", () => {
            window.location.href = "/login/google";
        });
    }
    if (lichessAuthBtn) {
        lichessAuthBtn.addEventListener("click", () => {
            window.location.href = "/login/lichess";
        });
    }
    checkAuth();
}
async function checkAuth() {
    try {
        const response = await fetch('/api/me');
        const data = await response.json();
        if (data.logged_in) {
            window.currentUser = data;
            updateAuthUI(data);
            if (window.renderRepertoireList) {
                await window.renderRepertoireList();
                handleAuthSuccessRedirect();
            }
        } else {
            window.currentUser = { logged_in: false };
            showLoginButtons();
        }
    } catch (error) {
        console.error('Auth check failed:', error);
        showLoginButtons();
    }
}
function updateAuthUI(user) {
    const userInfoMobile = document.getElementById("user-info-mobile");
    const userInfoDesktop = document.getElementById("user-info-desktop");
    if (!user || !user.logged_in) return;
    let mobileUsername = user.username || 'User';
    const originalUsername = mobileUsername;
    if (mobileUsername.length > 9) {
        mobileUsername = mobileUsername.substring(0, 9) + '...';
    }
    const logoutHtml = `<a href="/logout" class="logout-btn">Logout</a>`;
    if (userInfoMobile) {
        userInfoMobile.innerHTML = `
            <div class="user-info">
                <div class="username" title="${originalUsername}">${mobileUsername}</div>
                ${logoutHtml}
            </div>
        `;
    }
    if (userInfoDesktop) {
        userInfoDesktop.innerHTML = `
            <div class="user-info">
                <span class="username">${user.username}</span>
                ${logoutHtml}
            </div>
        `;
    }
}
function showLoginButtons() {
    const userInfoMobile = document.getElementById("user-info-mobile");
    const userInfoDesktop = document.getElementById("user-info-desktop");
    const btnHtml = (id) => `<button class="sign-in-btn" id="${id}">Sign In</button>`;
    if (userInfoMobile) {
        userInfoMobile.innerHTML = btnHtml("sign-in-btn-mobile");
        const btn = document.getElementById("sign-in-btn-mobile");
        if (btn) btn.addEventListener("click", () => document.getElementById("login-modal").style.display = "flex");
    }
    if (userInfoDesktop) {
        userInfoDesktop.innerHTML = btnHtml("sign-in-btn-desktop");
        const btn = document.getElementById("sign-in-btn-desktop");
        if (btn) btn.addEventListener("click", () => document.getElementById("login-modal").style.display = "flex");
    }
}
function handleAuthSuccessRedirect() {
    const urlParams = new URLSearchParams(window.location.search);
    if (urlParams.get('auth') === 'success') {
        const sidebar = document.getElementById('repertoire-sidebar');
        const mainContent = document.getElementById('main-content');
        if (sidebar && !sidebar.classList.contains('active')) {
            sidebar.classList.add('active');
            if (mainContent) mainContent.classList.add('sidebar-active');
            const newUrl = window.location.pathname + window.location.search.replace(/[\?&]auth=success/, '').replace(/^&/, '?');
            window.history.replaceState({}, document.title, newUrl);
        }
    }
}
