// Functions for drawing and clearing visual move hints on the board

export function showRepertoireArrows(chessground, node, threshold) {
  if (!chessground || !node || !Array.isArray(node.children)) {
    return;
  }
  const hintShapes = node.children
    .filter(child => {
      const valueToCheck = typeof child.displayValue === 'number' ? child.displayValue :
        (typeof child.value === 'number' ? child.value : 0);
      return valueToCheck < threshold;
    })
    .map(child => {
      if (!child.from || !child.to) {
        return null;
      }
      return {
        orig: child.from,
        dest: child.to,
        brush: 'green',
        key: `${child.from}-${child.to}`
      };
    })
    .filter(Boolean);
  chessground.set({
    drawable: {
      autoShapes: hintShapes
    }
  });
}
export function clearRepertoireArrows(chessground) {
  if (!chessground) {
    return;
  }
  chessground.set({
    drawable: {
      autoShapes: []
    }
  });
} 