// Main linking file for the training logic

import { state } from './state.js';
import * as DOM from './dom.js';
import * as ACTIONS from './actions.js';
import * as BOARD from './board.js';
import * as UI from './ui.js';
import * as REPERTOIRE from './repertoire.js';
import * as TRAINING from './training.js';
export function initializeEventListeners() {
    if (DOM.sidebarToggleBtn) DOM.sidebarToggleBtn.addEventListener('click', UI.toggleSidebar);
    if (DOM.mobileMenuBtn) DOM.mobileMenuBtn.addEventListener('click', UI.toggleSidebar);
    if (DOM.flipBoardButton) DOM.flipBoardButton.addEventListener('click', BOARD.flipBoard);
    if (DOM.hintButton) DOM.hintButton.addEventListener('click', UI.showHint);
    if (DOM.backMoveBtn) DOM.backMoveBtn.addEventListener('click', () => ACTIONS.navigateHalfMove(-1));
    if (DOM.forwardMoveBtn) DOM.forwardMoveBtn.addEventListener('click', () => ACTIONS.navigateHalfMove(1));
    const toggleTreeBtn = document.getElementById('toggle-tree-btn');
    if (toggleTreeBtn) {
        toggleTreeBtn.addEventListener('click', ACTIONS.toggleFullTree);
    }
    if (DOM.pgnImportForm) DOM.pgnImportForm.addEventListener('submit', (e) => {
        e.preventDefault();
        REPERTOIRE.importPgnForTraining(DOM.pgnTextArea.value, DOM.pgnNameInput.value);
    });
    if (DOM.samplePgnButton) DOM.samplePgnButton.addEventListener('click', REPERTOIRE.loadSamplePGN);
    document.addEventListener('keydown', ACTIONS.handleKeyPress);
    if (DOM.exploreRepertoireBtn) {
        DOM.exploreRepertoireBtn.addEventListener('click', ACTIONS.enterExploreMode);
    }
    if (DOM.goBackBtn) {
        DOM.goBackBtn.addEventListener('click', ACTIONS.exitExploreMode);
    }
    if (DOM.trainFromHereBtn) {
        DOM.trainFromHereBtn.addEventListener('click', () => {
            state.isExploreMode = false;
            DOM.exploreRepertoireBtn.style.display = 'block';
            DOM.trainActionsContainer.style.display = 'none';
            if (DOM.backMoveBtn) DOM.backMoveBtn.style.display = 'none';
            if (DOM.forwardMoveBtn) DOM.forwardMoveBtn.style.display = 'none';
            REPERTOIRE.createSubRepertoireAndTrain(state.game.fen());
        });
    }
    if (DOM.goBackToMainBtn) {
        DOM.goBackToMainBtn.addEventListener('click', REPERTOIRE.restoreOriginalRepertoire);
    }
    window.addEventListener('resize', () => {
        if (state.ground) {
            state.ground.redrawAll();
        }
    });
    if (DOM.mainContent) {
        DOM.mainContent.addEventListener('click', (e) => {
            if (DOM.sidebar.classList.contains('active') && !DOM.sidebarToggleBtn.contains(e.target)) {
                UI.toggleSidebar();
            }
        });
    }
}
export function initTraining(pgn, name, color) {
    window.renderRepertoireList = REPERTOIRE.renderRepertoireList;
    REPERTOIRE.renderRepertoireList();
    BOARD.initializeBoard({
        onUserMove: TRAINING.onUserMove,
        onBoardMove: TRAINING.onBoardMove
    });
    if (DOM.backMoveBtn) DOM.backMoveBtn.style.display = 'none';
    if (DOM.forwardMoveBtn) DOM.forwardMoveBtn.style.display = 'none';
    if (pgn && name) {
        if (DOM.openingNameElement) {
            DOM.openingNameElement.textContent = 'Loading...';
        }
        if (DOM.pgnViewerElement) {
            DOM.pgnViewerElement.innerHTML = '';
            DOM.pgnViewerElement.classList.add('loading');
            DOM.pgnViewerElement.style.textAlign = 'center';
            DOM.pgnViewerElement.textContent = 'Loading...';
        }
    }
    initializeEventListeners();
    if (pgn && name) {
        setTimeout(() => {
            REPERTOIRE.loadRepertoireFromData(pgn, name, color);
        }, 100);
    } else {
        if (DOM.pgnViewerElement) {
            DOM.pgnViewerElement.classList.remove('loading');
            DOM.pgnViewerElement.style.textAlign = 'left';
            DOM.pgnViewerElement.innerHTML = '<p>Select a repertoire from the sidebar to start training.</p>';
        }
        const progressLegend = document.querySelector('.progress-legend');
        if (progressLegend) progressLegend.style.display = 'none';
        if (DOM.feedbackContainerElement) DOM.feedbackContainerElement.style.display = 'none';
        if (DOM.exploreRepertoireBtn) DOM.exploreRepertoireBtn.style.display = 'none';
        const noRepertoireMessage = document.getElementById('no-repertoire-message');
        if (noRepertoireMessage) noRepertoireMessage.style.display = 'block';
        const trainingHeader = document.querySelector('.training-header');
        if (trainingHeader) trainingHeader.style.display = 'none';
    }
}
