// SRS (Spaced Repetition System) implementation for tracking and saving user progress.
import { state } from './state.js';
import { LEARNED_THRESHOLD } from './constants.js';
import { updateOpeningTreeProgress } from './ui.js';
export function saveProgress() {
    if (!state.repertoire) return;
    const nodeProgress = {};
    for (const fen in state.repertoire.fenMap) {
        const node = state.repertoire.fenMap[fen];
        if (node.san) {
            nodeProgress[fen] = {
                value: node.value || 0,
                updated: node.updated || null
            };
        }
    }
    const branchProgress = state.branches.map(b => ({ id: b.id, practiced: b.practiced }));
    const learnedNodesArray = state.repertoire.learnedNodes ? Array.from(state.repertoire.learnedNodes) : [];
    const progress = {
        nodes: nodeProgress,
        branches: branchProgress,
        learnedNodes: learnedNodesArray
    };
    localStorage.setItem(`progress_${state.repertoire.name}`, JSON.stringify(progress));
}
export function loadProgress() {
    if (!state.repertoire) return;
    const savedProgress = localStorage.getItem(`progress_${state.repertoire.name}`);
    if (savedProgress) {
        try {
            const progressData = JSON.parse(savedProgress);
            if (!state.repertoire.learnedNodes) {
                state.repertoire.learnedNodes = new Set();
            }
            if (progressData.nodes) {
                for (const fen in progressData.nodes) {
                    if (state.repertoire.fenMap[fen]) {
                        state.repertoire.fenMap[fen].value = progressData.nodes[fen].value;
                        state.repertoire.fenMap[fen].updated = progressData.nodes[fen].updated;
                        if (progressData.nodes[fen].value >= LEARNED_THRESHOLD) {
                            const shortFen = fen.split(' ')[0];
                            state.repertoire.learnedNodes.add(shortFen);
                        }
                    }
                }
            }
            if (progressData.learnedNodes) {
                progressData.learnedNodes.forEach(shortFen => {
                    state.repertoire.learnedNodes.add(shortFen);
                });
            }
            if (progressData.branches) {
                progressData.branches.forEach(p => {
                    const branch = state.branches.find(b => b.id === p.id);
                    if (branch) {
                        branch.practiced = p.practiced;
                    }
                });
            }
        } catch (e) {
            localStorage.removeItem(`progress_${state.repertoire.name}`);
        }
    }
    updateOpeningTreeProgress();
}
