// Utility functions for FEN manipulation, formatting and general helpers

import { state } from './state.js';
export function getChessInstance(fen = null) {
    if (state.chessInstancePool.length <= state.poolIndex) {
        state.chessInstancePool.push(new Chess());
    }
    const chess = state.chessInstancePool[state.poolIndex++];
    if (fen) chess.load(fen);
    return chess;
}
export function releaseChessInstances() {
    state.poolIndex = 0;
}
export function toDests(chess) {
    const dests = new Map();
    chess.SQUARES.forEach(s => {
        const ms = chess.moves({ square: s, verbose: true });
        if (ms.length) dests.set(s, ms.map(m => m.to));
    });
    return dests;
}
export function toColor(chess) {
    return (chess.turn() === 'w') ? 'white' : 'black';
}
export function getLastMove(chess) {
    const history = chess.history({ verbose: true });
    if (history.length > 0) {
        const lastMove = history[history.length - 1];
        return [lastMove.from, lastMove.to];
    }
    return [];
}
export function findMoveIndexInBranch(branch, fen) {
    const index = branch.moves.findIndex(m => m.fen.startsWith(fen.split(' ')[0]));
    return index !== -1 ? index + 1 : 0;
}
export function findBranchForMove(fen, san) {
    return state.branches.find(b => b.trunkFEN.startsWith(fen.split(' ')[0]) && b.moves[0].san === san);
}
